package zio.aws.privatenetworks.model
import scala.jdk.CollectionConverters.*
sealed trait NetworkResourceDefinitionType {
  def unwrap: software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType
}
object NetworkResourceDefinitionType {
  def wrap(
      value: software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType
  ): zio.aws.privatenetworks.model.NetworkResourceDefinitionType = value match {
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType.RADIO_UNIT =>
      val r = RADIO_UNIT
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType.DEVICE_IDENTIFIER =>
      val r = DEVICE_IDENTIFIER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.privatenetworks.model.NetworkResourceDefinitionType {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType.UNKNOWN_TO_SDK_VERSION
  }
  case object RADIO_UNIT
      extends zio.aws.privatenetworks.model.NetworkResourceDefinitionType {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType.RADIO_UNIT
  }
  case object DEVICE_IDENTIFIER
      extends zio.aws.privatenetworks.model.NetworkResourceDefinitionType {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinitionType.DEVICE_IDENTIFIER
  }
}
