package zio.aws.privatenetworks.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.privatenetworks.model.primitives.NetworkResourceDefinitionCountInteger
import scala.jdk.CollectionConverters.*
final case class NetworkResourceDefinition(
    count: NetworkResourceDefinitionCountInteger,
    options: Optional[Iterable[zio.aws.privatenetworks.model.NameValuePair]] =
      Optional.Absent,
    `type`: zio.aws.privatenetworks.model.NetworkResourceDefinitionType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinition = {
    import NetworkResourceDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinition
      .builder()
      .count(NetworkResourceDefinitionCountInteger.unwrap(count): Integer)
      .optionallyWith(
        options.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.options)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.NetworkResourceDefinition.ReadOnly =
    zio.aws.privatenetworks.model.NetworkResourceDefinition
      .wrap(buildAwsValue())
}
object NetworkResourceDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.NetworkResourceDefinition =
      zio.aws.privatenetworks.model.NetworkResourceDefinition(
        count,
        options.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        `type`
      )
    def count: NetworkResourceDefinitionCountInteger
    def options
        : Optional[List[zio.aws.privatenetworks.model.NameValuePair.ReadOnly]]
    def `type`: zio.aws.privatenetworks.model.NetworkResourceDefinitionType
    def getCount: ZIO[Any, Nothing, NetworkResourceDefinitionCountInteger] =
      ZIO.succeed(count)
    def getOptions: ZIO[Any, AwsError, List[
      zio.aws.privatenetworks.model.NameValuePair.ReadOnly
    ]] = AwsError.unwrapOptionField("options", options)
    def getType: ZIO[
      Any,
      Nothing,
      zio.aws.privatenetworks.model.NetworkResourceDefinitionType
    ] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinition
  ) extends zio.aws.privatenetworks.model.NetworkResourceDefinition.ReadOnly {
    override val count: NetworkResourceDefinitionCountInteger =
      zio.aws.privatenetworks.model.primitives
        .NetworkResourceDefinitionCountInteger(impl.count())
    override val options
        : Optional[List[zio.aws.privatenetworks.model.NameValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.privatenetworks.model.NameValuePair.wrap(item)
          }.toList
        )
    override val `type`
        : zio.aws.privatenetworks.model.NetworkResourceDefinitionType =
      zio.aws.privatenetworks.model.NetworkResourceDefinitionType
        .wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.NetworkResourceDefinition
  ): zio.aws.privatenetworks.model.NetworkResourceDefinition.ReadOnly =
    new Wrapper(impl)
}
