package zio.aws.privatenetworks.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.privatenetworks.model.primitives.{Arn, Description, Timestamp}
import scala.jdk.CollectionConverters.*
final case class NetworkResource(
    attributes: Optional[
      Iterable[zio.aws.privatenetworks.model.NameValuePair]
    ] = Optional.Absent,
    commitmentInformation: Optional[
      zio.aws.privatenetworks.model.CommitmentInformation
    ] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    health: Optional[zio.aws.privatenetworks.model.HealthStatus] =
      Optional.Absent,
    model: Optional[String] = Optional.Absent,
    networkArn: Optional[Arn] = Optional.Absent,
    networkResourceArn: Optional[Arn] = Optional.Absent,
    networkSiteArn: Optional[Arn] = Optional.Absent,
    orderArn: Optional[Arn] = Optional.Absent,
    position: Optional[zio.aws.privatenetworks.model.Position] =
      Optional.Absent,
    returnInformation: Optional[
      zio.aws.privatenetworks.model.ReturnInformation
    ] = Optional.Absent,
    serialNumber: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.privatenetworks.model.NetworkResourceStatus] =
      Optional.Absent,
    statusReason: Optional[String] = Optional.Absent,
    `type`: Optional[zio.aws.privatenetworks.model.NetworkResourceType] =
      Optional.Absent,
    vendor: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.NetworkResource = {
    import NetworkResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.NetworkResource
      .builder()
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        commitmentInformation.map(value => value.buildAwsValue())
      )(_.commitmentInformation)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(health.map(value => value.unwrap))(_.health)
      .optionallyWith(model.map(value => value: java.lang.String))(_.model)
      .optionallyWith(
        networkArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkArn)
      .optionallyWith(
        networkResourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkResourceArn)
      .optionallyWith(
        networkSiteArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkSiteArn)
      .optionallyWith(
        orderArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.orderArn)
      .optionallyWith(position.map(value => value.buildAwsValue()))(_.position)
      .optionallyWith(returnInformation.map(value => value.buildAwsValue()))(
        _.returnInformation
      )
      .optionallyWith(serialNumber.map(value => value: java.lang.String))(
        _.serialNumber
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(vendor.map(value => value: java.lang.String))(_.vendor)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.NetworkResource.ReadOnly =
    zio.aws.privatenetworks.model.NetworkResource.wrap(buildAwsValue())
}
object NetworkResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.NetworkResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.NetworkResource =
      zio.aws.privatenetworks.model.NetworkResource(
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        commitmentInformation.map(value => value.asEditable),
        createdAt.map(value => value),
        description.map(value => value),
        health.map(value => value),
        model.map(value => value),
        networkArn.map(value => value),
        networkResourceArn.map(value => value),
        networkSiteArn.map(value => value),
        orderArn.map(value => value),
        position.map(value => value.asEditable),
        returnInformation.map(value => value.asEditable),
        serialNumber.map(value => value),
        status.map(value => value),
        statusReason.map(value => value),
        `type`.map(value => value),
        vendor.map(value => value)
      )
    def attributes
        : Optional[List[zio.aws.privatenetworks.model.NameValuePair.ReadOnly]]
    def commitmentInformation
        : Optional[zio.aws.privatenetworks.model.CommitmentInformation.ReadOnly]
    def createdAt: Optional[Timestamp]
    def description: Optional[Description]
    def health: Optional[zio.aws.privatenetworks.model.HealthStatus]
    def model: Optional[String]
    def networkArn: Optional[Arn]
    def networkResourceArn: Optional[Arn]
    def networkSiteArn: Optional[Arn]
    def orderArn: Optional[Arn]
    def position: Optional[zio.aws.privatenetworks.model.Position.ReadOnly]
    def returnInformation
        : Optional[zio.aws.privatenetworks.model.ReturnInformation.ReadOnly]
    def serialNumber: Optional[String]
    def status: Optional[zio.aws.privatenetworks.model.NetworkResourceStatus]
    def statusReason: Optional[String]
    def `type`: Optional[zio.aws.privatenetworks.model.NetworkResourceType]
    def vendor: Optional[String]
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.privatenetworks.model.NameValuePair.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getCommitmentInformation: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.CommitmentInformation.ReadOnly
    ] =
      AwsError.unwrapOptionField("commitmentInformation", commitmentInformation)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getHealth
        : ZIO[Any, AwsError, zio.aws.privatenetworks.model.HealthStatus] =
      AwsError.unwrapOptionField("health", health)
    def getModel: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("model", model)
    def getNetworkArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkArn", networkArn)
    def getNetworkResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkResourceArn", networkResourceArn)
    def getNetworkSiteArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkSiteArn", networkSiteArn)
    def getOrderArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("orderArn", orderArn)
    def getPosition
        : ZIO[Any, AwsError, zio.aws.privatenetworks.model.Position.ReadOnly] =
      AwsError.unwrapOptionField("position", position)
    def getReturnInformation: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.ReturnInformation.ReadOnly
    ] = AwsError.unwrapOptionField("returnInformation", returnInformation)
    def getSerialNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.NetworkResourceStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
    def getType: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.NetworkResourceType
    ] = AwsError.unwrapOptionField("type", `type`)
    def getVendor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vendor", vendor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.NetworkResource
  ) extends zio.aws.privatenetworks.model.NetworkResource.ReadOnly {
    override val attributes
        : Optional[List[zio.aws.privatenetworks.model.NameValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.privatenetworks.model.NameValuePair.wrap(item)
          }.toList
        )
    override val commitmentInformation: Optional[
      zio.aws.privatenetworks.model.CommitmentInformation.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commitmentInformation())
      .map(value =>
        zio.aws.privatenetworks.model.CommitmentInformation.wrap(value)
      )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.privatenetworks.model.primitives.Timestamp(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.privatenetworks.model.primitives.Description(value))
    override val health: Optional[zio.aws.privatenetworks.model.HealthStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.health())
        .map(value => zio.aws.privatenetworks.model.HealthStatus.wrap(value))
    override val model: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.model())
      .map(value => value: String)
    override val networkArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.networkArn())
      .map(value => zio.aws.privatenetworks.model.primitives.Arn(value))
    override val networkResourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.networkResourceArn())
      .map(value => zio.aws.privatenetworks.model.primitives.Arn(value))
    override val networkSiteArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.networkSiteArn())
      .map(value => zio.aws.privatenetworks.model.primitives.Arn(value))
    override val orderArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.orderArn())
      .map(value => zio.aws.privatenetworks.model.primitives.Arn(value))
    override val position
        : Optional[zio.aws.privatenetworks.model.Position.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.position())
        .map(value => zio.aws.privatenetworks.model.Position.wrap(value))
    override val returnInformation
        : Optional[zio.aws.privatenetworks.model.ReturnInformation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.returnInformation())
        .map(value =>
          zio.aws.privatenetworks.model.ReturnInformation.wrap(value)
        )
    override val serialNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.serialNumber())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.privatenetworks.model.NetworkResourceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.privatenetworks.model.NetworkResourceStatus.wrap(value)
        )
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
    override val `type`
        : Optional[zio.aws.privatenetworks.model.NetworkResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value =>
          zio.aws.privatenetworks.model.NetworkResourceType.wrap(value)
        )
    override val vendor: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vendor())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.NetworkResource
  ): zio.aws.privatenetworks.model.NetworkResource.ReadOnly = new Wrapper(impl)
}
