package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NameValuePair(
    name: String,
    value: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.NameValuePair = {
    import NameValuePair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.NameValuePair
      .builder()
      .name(name: java.lang.String)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.NameValuePair.ReadOnly =
    zio.aws.privatenetworks.model.NameValuePair.wrap(buildAwsValue())
}
object NameValuePair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.NameValuePair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.NameValuePair =
      zio.aws.privatenetworks.model
        .NameValuePair(name, value.map(value => value))
    def name: String
    def value: Optional[String]
    def getName: ZIO[Any, Nothing, String] = ZIO.succeed(name)
    def getValue: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.NameValuePair
  ) extends zio.aws.privatenetworks.model.NameValuePair.ReadOnly {
    override val name: String = impl.name(): String
    override val value: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.NameValuePair
  ): zio.aws.privatenetworks.model.NameValuePair.ReadOnly = new Wrapper(impl)
}
