package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListOrdersResponse(
    nextToken: Optional[PaginationToken] = Optional.Absent,
    orders: Optional[Iterable[zio.aws.privatenetworks.model.Order]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse = {
    import ListOrdersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        orders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orders)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.ListOrdersResponse.ReadOnly =
    zio.aws.privatenetworks.model.ListOrdersResponse.wrap(buildAwsValue())
}
object ListOrdersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ListOrdersResponse =
      zio.aws.privatenetworks.model.ListOrdersResponse(
        nextToken.map(value => value),
        orders.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[PaginationToken]
    def orders: Optional[List[zio.aws.privatenetworks.model.Order.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getOrders: ZIO[Any, AwsError, List[
      zio.aws.privatenetworks.model.Order.ReadOnly
    ]] = AwsError.unwrapOptionField("orders", orders)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse
  ) extends zio.aws.privatenetworks.model.ListOrdersResponse.ReadOnly {
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.PaginationToken(value)
      )
    override val orders
        : Optional[List[zio.aws.privatenetworks.model.Order.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.orders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.privatenetworks.model.Order.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListOrdersResponse
  ): zio.aws.privatenetworks.model.ListOrdersResponse.ReadOnly = new Wrapper(
    impl
  )
}
