package zio.aws.privatenetworks.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.privatenetworks.model.primitives.{
  PaginationToken,
  ListNetworksRequestMaxResultsInteger
}
import scala.jdk.CollectionConverters.*
final case class ListNetworksRequest(
    filters: Optional[
      Map[zio.aws.privatenetworks.model.NetworkFilterKeys, Iterable[String]]
    ] = Optional.Absent,
    maxResults: Optional[ListNetworksRequestMaxResultsInteger] =
      Optional.Absent,
    startToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest = {
    import ListNetworksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filtersWithStrings)
      .optionallyWith(
        maxResults.map(value =>
          ListNetworksRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        startToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.startToken)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.ListNetworksRequest.ReadOnly =
    zio.aws.privatenetworks.model.ListNetworksRequest.wrap(buildAwsValue())
}
object ListNetworksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ListNetworksRequest =
      zio.aws.privatenetworks.model.ListNetworksRequest(
        filters.map(value => value),
        maxResults.map(value => value),
        startToken.map(value => value)
      )
    def filters: Optional[
      Map[zio.aws.privatenetworks.model.NetworkFilterKeys, List[String]]
    ]
    def maxResults: Optional[ListNetworksRequestMaxResultsInteger]
    def startToken: Optional[PaginationToken]
    def getFilters: ZIO[Any, AwsError, Map[
      zio.aws.privatenetworks.model.NetworkFilterKeys,
      List[String]
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults
        : ZIO[Any, AwsError, ListNetworksRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getStartToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("startToken", startToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest
  ) extends zio.aws.privatenetworks.model.ListNetworksRequest.ReadOnly {
    override val filters: Optional[
      Map[zio.aws.privatenetworks.model.NetworkFilterKeys, List[String]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.NetworkFilterKeys
              .wrap(key) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
    override val maxResults: Optional[ListNetworksRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.privatenetworks.model.primitives
            .ListNetworksRequestMaxResultsInteger(value)
        )
    override val startToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.startToken())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListNetworksRequest
  ): zio.aws.privatenetworks.model.ListNetworksRequest.ReadOnly = new Wrapper(
    impl
  )
}
