package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListNetworkResourcesResponse(
    networkResources: Optional[
      Iterable[zio.aws.privatenetworks.model.NetworkResource]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse = {
    import ListNetworkResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse
      .builder()
      .optionallyWith(
        networkResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkResources)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ListNetworkResourcesResponse.ReadOnly =
    zio.aws.privatenetworks.model.ListNetworkResourcesResponse
      .wrap(buildAwsValue())
}
object ListNetworkResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ListNetworkResourcesResponse =
      zio.aws.privatenetworks.model.ListNetworkResourcesResponse(
        networkResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkResources
        : Optional[List[zio.aws.privatenetworks.model.NetworkResource.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getNetworkResources: ZIO[Any, AwsError, List[
      zio.aws.privatenetworks.model.NetworkResource.ReadOnly
    ]] = AwsError.unwrapOptionField("networkResources", networkResources)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse
  ) extends zio.aws.privatenetworks.model.ListNetworkResourcesResponse.ReadOnly {
    override val networkResources: Optional[
      List[zio.aws.privatenetworks.model.NetworkResource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.networkResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.privatenetworks.model.NetworkResource.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesResponse
  ): zio.aws.privatenetworks.model.ListNetworkResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
