package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDeviceIdentifiersResponse(
    deviceIdentifiers: Optional[
      Iterable[zio.aws.privatenetworks.model.DeviceIdentifier]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse = {
    import ListDeviceIdentifiersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse
      .builder()
      .optionallyWith(
        deviceIdentifiers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deviceIdentifiers)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse.ReadOnly =
    zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse
      .wrap(buildAwsValue())
}
object ListDeviceIdentifiersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse =
      zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse(
        deviceIdentifiers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def deviceIdentifiers: Optional[
      List[zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly]
    ]
    def nextToken: Optional[PaginationToken]
    def getDeviceIdentifiers: ZIO[Any, AwsError, List[
      zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly
    ]] = AwsError.unwrapOptionField("deviceIdentifiers", deviceIdentifiers)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse
  ) extends zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse.ReadOnly {
    override val deviceIdentifiers: Optional[
      List[zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.privatenetworks.model.DeviceIdentifier.wrap(item)
        }.toList
      )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersResponse
  ): zio.aws.privatenetworks.model.ListDeviceIdentifiersResponse.ReadOnly =
    new Wrapper(impl)
}
