package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDeviceIdentifierRequest(deviceIdentifierArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierRequest = {
    import GetDeviceIdentifierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierRequest
      .builder()
      .deviceIdentifierArn(Arn.unwrap(deviceIdentifierArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.GetDeviceIdentifierRequest.ReadOnly =
    zio.aws.privatenetworks.model.GetDeviceIdentifierRequest
      .wrap(buildAwsValue())
}
object GetDeviceIdentifierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.GetDeviceIdentifierRequest =
      zio.aws.privatenetworks.model
        .GetDeviceIdentifierRequest(deviceIdentifierArn)
    def deviceIdentifierArn: Arn
    def getDeviceIdentifierArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(deviceIdentifierArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierRequest
  ) extends zio.aws.privatenetworks.model.GetDeviceIdentifierRequest.ReadOnly {
    override val deviceIdentifierArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.deviceIdentifierArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetDeviceIdentifierRequest
  ): zio.aws.privatenetworks.model.GetDeviceIdentifierRequest.ReadOnly =
    new Wrapper(impl)
}
