package zio.aws.privatenetworks.model
import scala.jdk.CollectionConverters.*
sealed trait ElevationReference {
  def unwrap
      : software.amazon.awssdk.services.privatenetworks.model.ElevationReference
}
object ElevationReference {
  def wrap(
      value: software.amazon.awssdk.services.privatenetworks.model.ElevationReference
  ): zio.aws.privatenetworks.model.ElevationReference = value match {
    case software.amazon.awssdk.services.privatenetworks.model.ElevationReference.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.privatenetworks.model.ElevationReference.AGL =>
      val r = AGL
      r
    case software.amazon.awssdk.services.privatenetworks.model.ElevationReference.AMSL =>
      val r = AMSL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.privatenetworks.model.ElevationReference {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.ElevationReference =
      software.amazon.awssdk.services.privatenetworks.model.ElevationReference.UNKNOWN_TO_SDK_VERSION
  }
  case object AGL extends zio.aws.privatenetworks.model.ElevationReference {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.ElevationReference =
      software.amazon.awssdk.services.privatenetworks.model.ElevationReference.AGL
  }
  case object AMSL extends zio.aws.privatenetworks.model.ElevationReference {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.ElevationReference =
      software.amazon.awssdk.services.privatenetworks.model.ElevationReference.AMSL
  }
}
