package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteNetworkResponse(
    network: zio.aws.privatenetworks.model.Network
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkResponse = {
    import DeleteNetworkResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkResponse
      .builder()
      .network(network.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.DeleteNetworkResponse.ReadOnly =
    zio.aws.privatenetworks.model.DeleteNetworkResponse.wrap(buildAwsValue())
}
object DeleteNetworkResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.DeleteNetworkResponse =
      zio.aws.privatenetworks.model.DeleteNetworkResponse(network.asEditable)
    def network: zio.aws.privatenetworks.model.Network.ReadOnly
    def getNetwork
        : ZIO[Any, Nothing, zio.aws.privatenetworks.model.Network.ReadOnly] =
      ZIO.succeed(network)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkResponse
  ) extends zio.aws.privatenetworks.model.DeleteNetworkResponse.ReadOnly {
    override val network: zio.aws.privatenetworks.model.Network.ReadOnly =
      zio.aws.privatenetworks.model.Network.wrap(impl.network())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkResponse
  ): zio.aws.privatenetworks.model.DeleteNetworkResponse.ReadOnly = new Wrapper(
    impl
  )
}
