package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{Arn, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteNetworkRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    networkArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkRequest = {
    import DeleteNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .networkArn(Arn.unwrap(networkArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.DeleteNetworkRequest.ReadOnly =
    zio.aws.privatenetworks.model.DeleteNetworkRequest.wrap(buildAwsValue())
}
object DeleteNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.DeleteNetworkRequest =
      zio.aws.privatenetworks.model
        .DeleteNetworkRequest(clientToken.map(value => value), networkArn)
    def clientToken: Optional[ClientToken]
    def networkArn: Arn
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getNetworkArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkRequest
  ) extends zio.aws.privatenetworks.model.DeleteNetworkRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.privatenetworks.model.primitives.ClientToken(value))
    override val networkArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkRequest
  ): zio.aws.privatenetworks.model.DeleteNetworkRequest.ReadOnly = new Wrapper(
    impl
  )
}
