package zio.aws.privatenetworks.model
import scala.jdk.CollectionConverters.*
sealed trait CommitmentLength {
  def unwrap
      : software.amazon.awssdk.services.privatenetworks.model.CommitmentLength
}
object CommitmentLength {
  def wrap(
      value: software.amazon.awssdk.services.privatenetworks.model.CommitmentLength
  ): zio.aws.privatenetworks.model.CommitmentLength = value match {
    case software.amazon.awssdk.services.privatenetworks.model.CommitmentLength.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.privatenetworks.model.CommitmentLength.SIXTY_DAYS =>
      val r = SIXTY_DAYS
      r
    case software.amazon.awssdk.services.privatenetworks.model.CommitmentLength.ONE_YEAR =>
      val r = ONE_YEAR
      r
    case software.amazon.awssdk.services.privatenetworks.model.CommitmentLength.THREE_YEARS =>
      val r = THREE_YEARS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.privatenetworks.model.CommitmentLength {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.CommitmentLength =
      software.amazon.awssdk.services.privatenetworks.model.CommitmentLength.UNKNOWN_TO_SDK_VERSION
  }
  case object SIXTY_DAYS
      extends zio.aws.privatenetworks.model.CommitmentLength {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.CommitmentLength =
      software.amazon.awssdk.services.privatenetworks.model.CommitmentLength.SIXTY_DAYS
  }
  case object ONE_YEAR extends zio.aws.privatenetworks.model.CommitmentLength {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.CommitmentLength =
      software.amazon.awssdk.services.privatenetworks.model.CommitmentLength.ONE_YEAR
  }
  case object THREE_YEARS
      extends zio.aws.privatenetworks.model.CommitmentLength {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.CommitmentLength =
      software.amazon.awssdk.services.privatenetworks.model.CommitmentLength.THREE_YEARS
  }
}
