package zio.aws.privatenetworks.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.privatenetworks.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class CommitmentInformation(
    commitmentConfiguration: zio.aws.privatenetworks.model.CommitmentConfiguration,
    expiresOn: Optional[Timestamp] = Optional.Absent,
    startAt: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.CommitmentInformation = {
    import CommitmentInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.CommitmentInformation
      .builder()
      .commitmentConfiguration(commitmentConfiguration.buildAwsValue())
      .optionallyWith(expiresOn.map(value => Timestamp.unwrap(value): Instant))(
        _.expiresOn
      )
      .optionallyWith(startAt.map(value => Timestamp.unwrap(value): Instant))(
        _.startAt
      )
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.CommitmentInformation.ReadOnly =
    zio.aws.privatenetworks.model.CommitmentInformation.wrap(buildAwsValue())
}
object CommitmentInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.CommitmentInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.CommitmentInformation =
      zio.aws.privatenetworks.model.CommitmentInformation(
        commitmentConfiguration.asEditable,
        expiresOn.map(value => value),
        startAt.map(value => value)
      )
    def commitmentConfiguration
        : zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly
    def expiresOn: Optional[Timestamp]
    def startAt: Optional[Timestamp]
    def getCommitmentConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly
    ] = ZIO.succeed(commitmentConfiguration)
    def getExpiresOn: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("expiresOn", expiresOn)
    def getStartAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startAt", startAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.CommitmentInformation
  ) extends zio.aws.privatenetworks.model.CommitmentInformation.ReadOnly {
    override val commitmentConfiguration
        : zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly =
      zio.aws.privatenetworks.model.CommitmentConfiguration
        .wrap(impl.commitmentConfiguration())
    override val expiresOn: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.expiresOn())
      .map(value => zio.aws.privatenetworks.model.primitives.Timestamp(value))
    override val startAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startAt())
      .map(value => zio.aws.privatenetworks.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.CommitmentInformation
  ): zio.aws.privatenetworks.model.CommitmentInformation.ReadOnly = new Wrapper(
    impl
  )
}
