package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CommitmentConfiguration(
    automaticRenewal: Boolean,
    commitmentLength: zio.aws.privatenetworks.model.CommitmentLength
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.CommitmentConfiguration = {
    import CommitmentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.CommitmentConfiguration
      .builder()
      .automaticRenewal(automaticRenewal: java.lang.Boolean)
      .commitmentLength(commitmentLength.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly =
    zio.aws.privatenetworks.model.CommitmentConfiguration.wrap(buildAwsValue())
}
object CommitmentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.CommitmentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.CommitmentConfiguration =
      zio.aws.privatenetworks.model
        .CommitmentConfiguration(automaticRenewal, commitmentLength)
    def automaticRenewal: Boolean
    def commitmentLength: zio.aws.privatenetworks.model.CommitmentLength
    def getAutomaticRenewal: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(automaticRenewal)
    def getCommitmentLength
        : ZIO[Any, Nothing, zio.aws.privatenetworks.model.CommitmentLength] =
      ZIO.succeed(commitmentLength)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.CommitmentConfiguration
  ) extends zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly {
    override val automaticRenewal: Boolean = impl.automaticRenewal(): Boolean
    override val commitmentLength
        : zio.aws.privatenetworks.model.CommitmentLength =
      zio.aws.privatenetworks.model.CommitmentLength
        .wrap(impl.commitmentLength())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.CommitmentConfiguration
  ): zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly =
    new Wrapper(impl)
}
