package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.AddressContent
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Address(
    city: AddressContent,
    company: Optional[AddressContent] = Optional.Absent,
    country: AddressContent,
    emailAddress: Optional[AddressContent] = Optional.Absent,
    name: AddressContent,
    phoneNumber: Optional[AddressContent] = Optional.Absent,
    postalCode: AddressContent,
    stateOrProvince: AddressContent,
    street1: AddressContent,
    street2: Optional[AddressContent] = Optional.Absent,
    street3: Optional[AddressContent] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.Address = {
    import Address.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.Address
      .builder()
      .city(AddressContent.unwrap(city): java.lang.String)
      .optionallyWith(
        company.map(value => AddressContent.unwrap(value): java.lang.String)
      )(_.company)
      .country(AddressContent.unwrap(country): java.lang.String)
      .optionallyWith(
        emailAddress.map(value =>
          AddressContent.unwrap(value): java.lang.String
        )
      )(_.emailAddress)
      .name(AddressContent.unwrap(name): java.lang.String)
      .optionallyWith(
        phoneNumber.map(value => AddressContent.unwrap(value): java.lang.String)
      )(_.phoneNumber)
      .postalCode(AddressContent.unwrap(postalCode): java.lang.String)
      .stateOrProvince(AddressContent.unwrap(stateOrProvince): java.lang.String)
      .street1(AddressContent.unwrap(street1): java.lang.String)
      .optionallyWith(
        street2.map(value => AddressContent.unwrap(value): java.lang.String)
      )(_.street2)
      .optionallyWith(
        street3.map(value => AddressContent.unwrap(value): java.lang.String)
      )(_.street3)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.Address.ReadOnly =
    zio.aws.privatenetworks.model.Address.wrap(buildAwsValue())
}
object Address {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.Address
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.Address =
      zio.aws.privatenetworks.model.Address(
        city,
        company.map(value => value),
        country,
        emailAddress.map(value => value),
        name,
        phoneNumber.map(value => value),
        postalCode,
        stateOrProvince,
        street1,
        street2.map(value => value),
        street3.map(value => value)
      )
    def city: AddressContent
    def company: Optional[AddressContent]
    def country: AddressContent
    def emailAddress: Optional[AddressContent]
    def name: AddressContent
    def phoneNumber: Optional[AddressContent]
    def postalCode: AddressContent
    def stateOrProvince: AddressContent
    def street1: AddressContent
    def street2: Optional[AddressContent]
    def street3: Optional[AddressContent]
    def getCity: ZIO[Any, Nothing, AddressContent] = ZIO.succeed(city)
    def getCompany: ZIO[Any, AwsError, AddressContent] =
      AwsError.unwrapOptionField("company", company)
    def getCountry: ZIO[Any, Nothing, AddressContent] = ZIO.succeed(country)
    def getEmailAddress: ZIO[Any, AwsError, AddressContent] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getName: ZIO[Any, Nothing, AddressContent] = ZIO.succeed(name)
    def getPhoneNumber: ZIO[Any, AwsError, AddressContent] =
      AwsError.unwrapOptionField("phoneNumber", phoneNumber)
    def getPostalCode: ZIO[Any, Nothing, AddressContent] =
      ZIO.succeed(postalCode)
    def getStateOrProvince: ZIO[Any, Nothing, AddressContent] =
      ZIO.succeed(stateOrProvince)
    def getStreet1: ZIO[Any, Nothing, AddressContent] = ZIO.succeed(street1)
    def getStreet2: ZIO[Any, AwsError, AddressContent] =
      AwsError.unwrapOptionField("street2", street2)
    def getStreet3: ZIO[Any, AwsError, AddressContent] =
      AwsError.unwrapOptionField("street3", street3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.Address
  ) extends zio.aws.privatenetworks.model.Address.ReadOnly {
    override val city: AddressContent =
      zio.aws.privatenetworks.model.primitives.AddressContent(impl.city())
    override val company: Optional[AddressContent] = zio.aws.core.internal
      .optionalFromNullable(impl.company())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.AddressContent(value)
      )
    override val country: AddressContent =
      zio.aws.privatenetworks.model.primitives.AddressContent(impl.country())
    override val emailAddress: Optional[AddressContent] = zio.aws.core.internal
      .optionalFromNullable(impl.emailAddress())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.AddressContent(value)
      )
    override val name: AddressContent =
      zio.aws.privatenetworks.model.primitives.AddressContent(impl.name())
    override val phoneNumber: Optional[AddressContent] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumber())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.AddressContent(value)
      )
    override val postalCode: AddressContent =
      zio.aws.privatenetworks.model.primitives.AddressContent(impl.postalCode())
    override val stateOrProvince: AddressContent =
      zio.aws.privatenetworks.model.primitives
        .AddressContent(impl.stateOrProvince())
    override val street1: AddressContent =
      zio.aws.privatenetworks.model.primitives.AddressContent(impl.street1())
    override val street2: Optional[AddressContent] = zio.aws.core.internal
      .optionalFromNullable(impl.street2())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.AddressContent(value)
      )
    override val street3: Optional[AddressContent] = zio.aws.core.internal
      .optionalFromNullable(impl.street3())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.AddressContent(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.Address
  ): zio.aws.privatenetworks.model.Address.ReadOnly = new Wrapper(impl)
}
