package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{Arn, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActivateNetworkSiteRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    commitmentConfiguration: Optional[
      zio.aws.privatenetworks.model.CommitmentConfiguration
    ] = Optional.Absent,
    networkSiteArn: Arn,
    shippingAddress: zio.aws.privatenetworks.model.Address
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteRequest = {
    import ActivateNetworkSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        commitmentConfiguration.map(value => value.buildAwsValue())
      )(_.commitmentConfiguration)
      .networkSiteArn(Arn.unwrap(networkSiteArn): java.lang.String)
      .shippingAddress(shippingAddress.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ActivateNetworkSiteRequest.ReadOnly =
    zio.aws.privatenetworks.model.ActivateNetworkSiteRequest
      .wrap(buildAwsValue())
}
object ActivateNetworkSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ActivateNetworkSiteRequest =
      zio.aws.privatenetworks.model.ActivateNetworkSiteRequest(
        clientToken.map(value => value),
        commitmentConfiguration.map(value => value.asEditable),
        networkSiteArn,
        shippingAddress.asEditable
      )
    def clientToken: Optional[ClientToken]
    def commitmentConfiguration: Optional[
      zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly
    ]
    def networkSiteArn: Arn
    def shippingAddress: zio.aws.privatenetworks.model.Address.ReadOnly
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCommitmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "commitmentConfiguration",
      commitmentConfiguration
    )
    def getNetworkSiteArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkSiteArn)
    def getShippingAddress
        : ZIO[Any, Nothing, zio.aws.privatenetworks.model.Address.ReadOnly] =
      ZIO.succeed(shippingAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteRequest
  ) extends zio.aws.privatenetworks.model.ActivateNetworkSiteRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.privatenetworks.model.primitives.ClientToken(value))
    override val commitmentConfiguration: Optional[
      zio.aws.privatenetworks.model.CommitmentConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.commitmentConfiguration())
      .map(value =>
        zio.aws.privatenetworks.model.CommitmentConfiguration.wrap(value)
      )
    override val networkSiteArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkSiteArn())
    override val shippingAddress
        : zio.aws.privatenetworks.model.Address.ReadOnly =
      zio.aws.privatenetworks.model.Address.wrap(impl.shippingAddress())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteRequest
  ): zio.aws.privatenetworks.model.ActivateNetworkSiteRequest.ReadOnly =
    new Wrapper(impl)
}
