package zio.aws.privatenetworks
import zio.aws.privatenetworks.model.primitives.{TagValue, TagKey}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.privatenetworks.model.primitives.TagKey.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AddressContent extends Subtype[String]
    type AddressContent =
      zio.aws.privatenetworks.model.primitives.AddressContent.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.privatenetworks.model.primitives.Arn.Type
    object ClientToken extends Subtype[String]
    type ClientToken = zio.aws.privatenetworks.model.primitives.ClientToken.Type
    object ConfigureAccessPointRequestCpiSecretKeyString extends Subtype[String]
    type ConfigureAccessPointRequestCpiSecretKeyString =
      zio.aws.privatenetworks.model.primitives.ConfigureAccessPointRequestCpiSecretKeyString.Type
    object ConfigureAccessPointRequestCpiUserIdString extends Subtype[String]
    type ConfigureAccessPointRequestCpiUserIdString =
      zio.aws.privatenetworks.model.primitives.ConfigureAccessPointRequestCpiUserIdString.Type
    object ConfigureAccessPointRequestCpiUserPasswordString
        extends Subtype[String]
    type ConfigureAccessPointRequestCpiUserPasswordString =
      zio.aws.privatenetworks.model.primitives.ConfigureAccessPointRequestCpiUserPasswordString.Type
    object ConfigureAccessPointRequestCpiUsernameString extends Subtype[String]
    type ConfigureAccessPointRequestCpiUsernameString =
      zio.aws.privatenetworks.model.primitives.ConfigureAccessPointRequestCpiUsernameString.Type
    object Description extends Subtype[String]
    type Description = zio.aws.privatenetworks.model.primitives.Description.Type
    object DeviceIdentifierImsiString extends Subtype[String]
    type DeviceIdentifierImsiString =
      zio.aws.privatenetworks.model.primitives.DeviceIdentifierImsiString.Type
    object ListDeviceIdentifiersRequestMaxResultsInteger extends Subtype[Int]
    type ListDeviceIdentifiersRequestMaxResultsInteger =
      zio.aws.privatenetworks.model.primitives.ListDeviceIdentifiersRequestMaxResultsInteger.Type
    object ListNetworkResourcesRequestMaxResultsInteger extends Subtype[Int]
    type ListNetworkResourcesRequestMaxResultsInteger =
      zio.aws.privatenetworks.model.primitives.ListNetworkResourcesRequestMaxResultsInteger.Type
    object ListNetworkSitesRequestMaxResultsInteger extends Subtype[Int]
    type ListNetworkSitesRequestMaxResultsInteger =
      zio.aws.privatenetworks.model.primitives.ListNetworkSitesRequestMaxResultsInteger.Type
    object ListNetworksRequestMaxResultsInteger extends Subtype[Int]
    type ListNetworksRequestMaxResultsInteger =
      zio.aws.privatenetworks.model.primitives.ListNetworksRequestMaxResultsInteger.Type
    object ListOrdersRequestMaxResultsInteger extends Subtype[Int]
    type ListOrdersRequestMaxResultsInteger =
      zio.aws.privatenetworks.model.primitives.ListOrdersRequestMaxResultsInteger.Type
    object Name extends Subtype[String]
    type Name = zio.aws.privatenetworks.model.primitives.Name.Type
    object NetworkResourceDefinitionCountInteger extends Subtype[Int]
    type NetworkResourceDefinitionCountInteger =
      zio.aws.privatenetworks.model.primitives.NetworkResourceDefinitionCountInteger.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.privatenetworks.model.primitives.PaginationToken.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.privatenetworks.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.privatenetworks.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.privatenetworks.model.primitives.Timestamp.Type
  }
  type DeviceIdentifierFilterValues = List[String]
  type DeviceIdentifierFilters =
    Map[zio.aws.privatenetworks.model.DeviceIdentifierFilterKeys, Iterable[
      String
    ]]
  type DeviceIdentifierList =
    List[zio.aws.privatenetworks.model.DeviceIdentifier]
  type NameValuePairs = List[zio.aws.privatenetworks.model.NameValuePair]
  type NetworkFilterValues = List[String]
  type NetworkFilters =
    Map[zio.aws.privatenetworks.model.NetworkFilterKeys, Iterable[String]]
  type NetworkList = List[zio.aws.privatenetworks.model.Network]
  type NetworkResourceDefinitions =
    List[zio.aws.privatenetworks.model.NetworkResourceDefinition]
  type NetworkResourceFilterValues = List[String]
  type NetworkResourceFilters =
    Map[zio.aws.privatenetworks.model.NetworkResourceFilterKeys, Iterable[
      String
    ]]
  type NetworkResourceList = List[zio.aws.privatenetworks.model.NetworkResource]
  type NetworkSiteFilterValues = List[String]
  type NetworkSiteFilters =
    Map[zio.aws.privatenetworks.model.NetworkSiteFilterKeys, Iterable[String]]
  type NetworkSiteList = List[zio.aws.privatenetworks.model.NetworkSite]
  type Options = List[zio.aws.privatenetworks.model.NameValuePair]
  type OrderFilterValues = List[String]
  type OrderFilters =
    Map[zio.aws.privatenetworks.model.OrderFilterKeys, Iterable[String]]
  type OrderList = List[zio.aws.privatenetworks.model.Order]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TrackingInformationList =
    List[zio.aws.privatenetworks.model.TrackingInformation]
}
