package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{Arn, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateNetworkSitePlanRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    networkSiteArn: Arn,
    pendingPlan: zio.aws.privatenetworks.model.SitePlan
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSitePlanRequest = {
    import UpdateNetworkSitePlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSitePlanRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .networkSiteArn(Arn.unwrap(networkSiteArn): java.lang.String)
      .pendingPlan(pendingPlan.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.UpdateNetworkSitePlanRequest.ReadOnly =
    zio.aws.privatenetworks.model.UpdateNetworkSitePlanRequest
      .wrap(buildAwsValue())
}
object UpdateNetworkSitePlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSitePlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.UpdateNetworkSitePlanRequest =
      zio.aws.privatenetworks.model.UpdateNetworkSitePlanRequest(
        clientToken.map(value => value),
        networkSiteArn,
        pendingPlan.asEditable
      )
    def clientToken: Optional[ClientToken]
    def networkSiteArn: Arn
    def pendingPlan: zio.aws.privatenetworks.model.SitePlan.ReadOnly
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getNetworkSiteArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkSiteArn)
    def getPendingPlan
        : ZIO[Any, Nothing, zio.aws.privatenetworks.model.SitePlan.ReadOnly] =
      ZIO.succeed(pendingPlan)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSitePlanRequest
  ) extends zio.aws.privatenetworks.model.UpdateNetworkSitePlanRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.privatenetworks.model.primitives.ClientToken(value))
    override val networkSiteArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkSiteArn())
    override val pendingPlan: zio.aws.privatenetworks.model.SitePlan.ReadOnly =
      zio.aws.privatenetworks.model.SitePlan.wrap(impl.pendingPlan())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSitePlanRequest
  ): zio.aws.privatenetworks.model.UpdateNetworkSitePlanRequest.ReadOnly =
    new Wrapper(impl)
}
