package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Position(
    elevation: Optional[Double] = Optional.Absent,
    elevationReference: Optional[
      zio.aws.privatenetworks.model.ElevationReference
    ] = Optional.Absent,
    elevationUnit: Optional[zio.aws.privatenetworks.model.ElevationUnit] =
      Optional.Absent,
    latitude: Optional[Double] = Optional.Absent,
    longitude: Optional[Double] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.Position = {
    import Position.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.Position
      .builder()
      .optionallyWith(elevation.map(value => value: java.lang.Double))(
        _.elevation
      )
      .optionallyWith(elevationReference.map(value => value.unwrap))(
        _.elevationReference
      )
      .optionallyWith(elevationUnit.map(value => value.unwrap))(_.elevationUnit)
      .optionallyWith(latitude.map(value => value: java.lang.Double))(
        _.latitude
      )
      .optionallyWith(longitude.map(value => value: java.lang.Double))(
        _.longitude
      )
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.Position.ReadOnly =
    zio.aws.privatenetworks.model.Position.wrap(buildAwsValue())
}
object Position {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.Position
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.Position =
      zio.aws.privatenetworks.model.Position(
        elevation.map(value => value),
        elevationReference.map(value => value),
        elevationUnit.map(value => value),
        latitude.map(value => value),
        longitude.map(value => value)
      )
    def elevation: Optional[Double]
    def elevationReference
        : Optional[zio.aws.privatenetworks.model.ElevationReference]
    def elevationUnit: Optional[zio.aws.privatenetworks.model.ElevationUnit]
    def latitude: Optional[Double]
    def longitude: Optional[Double]
    def getElevation: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("elevation", elevation)
    def getElevationReference
        : ZIO[Any, AwsError, zio.aws.privatenetworks.model.ElevationReference] =
      AwsError.unwrapOptionField("elevationReference", elevationReference)
    def getElevationUnit
        : ZIO[Any, AwsError, zio.aws.privatenetworks.model.ElevationUnit] =
      AwsError.unwrapOptionField("elevationUnit", elevationUnit)
    def getLatitude: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("latitude", latitude)
    def getLongitude: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("longitude", longitude)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.Position
  ) extends zio.aws.privatenetworks.model.Position.ReadOnly {
    override val elevation: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.elevation())
      .map(value => value: Double)
    override val elevationReference
        : Optional[zio.aws.privatenetworks.model.ElevationReference] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elevationReference())
        .map(value =>
          zio.aws.privatenetworks.model.ElevationReference.wrap(value)
        )
    override val elevationUnit
        : Optional[zio.aws.privatenetworks.model.ElevationUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.elevationUnit())
        .map(value => zio.aws.privatenetworks.model.ElevationUnit.wrap(value))
    override val latitude: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.latitude())
      .map(value => value: Double)
    override val longitude: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.longitude())
      .map(value => value: Double)
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.Position
  ): zio.aws.privatenetworks.model.Position.ReadOnly = new Wrapper(impl)
}
