package zio.aws.privatenetworks.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.privatenetworks.model.primitives.{
  Name,
  Arn,
  Description,
  Timestamp
}
import scala.jdk.CollectionConverters.*
final case class NetworkSite(
    availabilityZone: Optional[String] = Optional.Absent,
    availabilityZoneId: Optional[String] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    currentPlan: Optional[zio.aws.privatenetworks.model.SitePlan] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    networkArn: Arn,
    networkSiteArn: Arn,
    networkSiteName: Name,
    pendingPlan: Optional[zio.aws.privatenetworks.model.SitePlan] =
      Optional.Absent,
    status: zio.aws.privatenetworks.model.NetworkSiteStatus,
    statusReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.NetworkSite = {
    import NetworkSite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.NetworkSite
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(currentPlan.map(value => value.buildAwsValue()))(
        _.currentPlan
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .networkArn(Arn.unwrap(networkArn): java.lang.String)
      .networkSiteArn(Arn.unwrap(networkSiteArn): java.lang.String)
      .networkSiteName(Name.unwrap(networkSiteName): java.lang.String)
      .optionallyWith(pendingPlan.map(value => value.buildAwsValue()))(
        _.pendingPlan
      )
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.NetworkSite.ReadOnly =
    zio.aws.privatenetworks.model.NetworkSite.wrap(buildAwsValue())
}
object NetworkSite {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.NetworkSite
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.NetworkSite =
      zio.aws.privatenetworks.model.NetworkSite(
        availabilityZone.map(value => value),
        availabilityZoneId.map(value => value),
        createdAt.map(value => value),
        currentPlan.map(value => value.asEditable),
        description.map(value => value),
        networkArn,
        networkSiteArn,
        networkSiteName,
        pendingPlan.map(value => value.asEditable),
        status,
        statusReason.map(value => value)
      )
    def availabilityZone: Optional[String]
    def availabilityZoneId: Optional[String]
    def createdAt: Optional[Timestamp]
    def currentPlan: Optional[zio.aws.privatenetworks.model.SitePlan.ReadOnly]
    def description: Optional[Description]
    def networkArn: Arn
    def networkSiteArn: Arn
    def networkSiteName: Name
    def pendingPlan: Optional[zio.aws.privatenetworks.model.SitePlan.ReadOnly]
    def status: zio.aws.privatenetworks.model.NetworkSiteStatus
    def statusReason: Optional[String]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getCurrentPlan
        : ZIO[Any, AwsError, zio.aws.privatenetworks.model.SitePlan.ReadOnly] =
      AwsError.unwrapOptionField("currentPlan", currentPlan)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNetworkArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkArn)
    def getNetworkSiteArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkSiteArn)
    def getNetworkSiteName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(networkSiteName)
    def getPendingPlan
        : ZIO[Any, AwsError, zio.aws.privatenetworks.model.SitePlan.ReadOnly] =
      AwsError.unwrapOptionField("pendingPlan", pendingPlan)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.privatenetworks.model.NetworkSiteStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.NetworkSite
  ) extends zio.aws.privatenetworks.model.NetworkSite.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val availabilityZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZoneId())
      .map(value => value: String)
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.privatenetworks.model.primitives.Timestamp(value))
    override val currentPlan
        : Optional[zio.aws.privatenetworks.model.SitePlan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentPlan())
        .map(value => zio.aws.privatenetworks.model.SitePlan.wrap(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.privatenetworks.model.primitives.Description(value))
    override val networkArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkArn())
    override val networkSiteArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkSiteArn())
    override val networkSiteName: Name =
      zio.aws.privatenetworks.model.primitives.Name(impl.networkSiteName())
    override val pendingPlan
        : Optional[zio.aws.privatenetworks.model.SitePlan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingPlan())
        .map(value => zio.aws.privatenetworks.model.SitePlan.wrap(value))
    override val status: zio.aws.privatenetworks.model.NetworkSiteStatus =
      zio.aws.privatenetworks.model.NetworkSiteStatus.wrap(impl.status())
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.NetworkSite
  ): zio.aws.privatenetworks.model.NetworkSite.ReadOnly = new Wrapper(impl)
}
