package zio.aws.privatenetworks.model
import scala.jdk.CollectionConverters.*
sealed trait NetworkResourceStatus {
  def unwrap: software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus
}
object NetworkResourceStatus {
  def wrap(
      value: software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus
  ): zio.aws.privatenetworks.model.NetworkResourceStatus = value match {
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.SHIPPED =>
      val r = SHIPPED
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.PROVISIONED =>
      val r = PROVISIONED
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.PENDING_RETURN =>
      val r = PENDING_RETURN
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.privatenetworks.model.NetworkResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING
      extends zio.aws.privatenetworks.model.NetworkResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.PENDING
  }
  case object SHIPPED
      extends zio.aws.privatenetworks.model.NetworkResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.SHIPPED
  }
  case object PROVISIONING
      extends zio.aws.privatenetworks.model.NetworkResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.PROVISIONING
  }
  case object PROVISIONED
      extends zio.aws.privatenetworks.model.NetworkResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.PROVISIONED
  }
  case object AVAILABLE
      extends zio.aws.privatenetworks.model.NetworkResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.AVAILABLE
  }
  case object DELETING
      extends zio.aws.privatenetworks.model.NetworkResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.DELETING
  }
  case object PENDING_RETURN
      extends zio.aws.privatenetworks.model.NetworkResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.PENDING_RETURN
  }
  case object DELETED
      extends zio.aws.privatenetworks.model.NetworkResourceStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceStatus.DELETED
  }
}
