package zio.aws.privatenetworks.model
import scala.jdk.CollectionConverters.*
sealed trait NetworkResourceFilterKeys {
  def unwrap: software.amazon.awssdk.services.privatenetworks.model.NetworkResourceFilterKeys
}
object NetworkResourceFilterKeys {
  def wrap(
      value: software.amazon.awssdk.services.privatenetworks.model.NetworkResourceFilterKeys
  ): zio.aws.privatenetworks.model.NetworkResourceFilterKeys = value match {
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceFilterKeys.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceFilterKeys.ORDER =>
      val r = ORDER
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkResourceFilterKeys.STATUS =>
      val r = STATUS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.privatenetworks.model.NetworkResourceFilterKeys {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceFilterKeys =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceFilterKeys.UNKNOWN_TO_SDK_VERSION
  }
  case object ORDER
      extends zio.aws.privatenetworks.model.NetworkResourceFilterKeys {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceFilterKeys =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceFilterKeys.ORDER
  }
  case object STATUS
      extends zio.aws.privatenetworks.model.NetworkResourceFilterKeys {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkResourceFilterKeys =
      software.amazon.awssdk.services.privatenetworks.model.NetworkResourceFilterKeys.STATUS
  }
}
