package zio.aws.privatenetworks.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.privatenetworks.model.primitives.{
  Name,
  Arn,
  Description,
  Timestamp
}
import scala.jdk.CollectionConverters.*
final case class Network(
    createdAt: Optional[Timestamp] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    networkArn: Arn,
    networkName: Name,
    status: zio.aws.privatenetworks.model.NetworkStatus,
    statusReason: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.Network = {
    import Network.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.Network
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .networkArn(Arn.unwrap(networkArn): java.lang.String)
      .networkName(Name.unwrap(networkName): java.lang.String)
      .status(status.unwrap)
      .optionallyWith(statusReason.map(value => value: java.lang.String))(
        _.statusReason
      )
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.Network.ReadOnly =
    zio.aws.privatenetworks.model.Network.wrap(buildAwsValue())
}
object Network {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.Network
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.Network =
      zio.aws.privatenetworks.model.Network(
        createdAt.map(value => value),
        description.map(value => value),
        networkArn,
        networkName,
        status,
        statusReason.map(value => value)
      )
    def createdAt: Optional[Timestamp]
    def description: Optional[Description]
    def networkArn: Arn
    def networkName: Name
    def status: zio.aws.privatenetworks.model.NetworkStatus
    def statusReason: Optional[String]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNetworkArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkArn)
    def getNetworkName: ZIO[Any, Nothing, Name] = ZIO.succeed(networkName)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.privatenetworks.model.NetworkStatus] =
      ZIO.succeed(status)
    def getStatusReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("statusReason", statusReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.Network
  ) extends zio.aws.privatenetworks.model.Network.ReadOnly {
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.privatenetworks.model.primitives.Timestamp(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.privatenetworks.model.primitives.Description(value))
    override val networkArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkArn())
    override val networkName: Name =
      zio.aws.privatenetworks.model.primitives.Name(impl.networkName())
    override val status: zio.aws.privatenetworks.model.NetworkStatus =
      zio.aws.privatenetworks.model.NetworkStatus.wrap(impl.status())
    override val statusReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.statusReason())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.Network
  ): zio.aws.privatenetworks.model.Network.ReadOnly = new Wrapper(impl)
}
