package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListNetworkSitesResponse(
    networkSites: Optional[
      Iterable[zio.aws.privatenetworks.model.NetworkSite]
    ] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse = {
    import ListNetworkSitesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse
      .builder()
      .optionallyWith(
        networkSites.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.networkSites)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ListNetworkSitesResponse.ReadOnly =
    zio.aws.privatenetworks.model.ListNetworkSitesResponse.wrap(buildAwsValue())
}
object ListNetworkSitesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ListNetworkSitesResponse =
      zio.aws.privatenetworks.model.ListNetworkSitesResponse(
        networkSites.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def networkSites
        : Optional[List[zio.aws.privatenetworks.model.NetworkSite.ReadOnly]]
    def nextToken: Optional[PaginationToken]
    def getNetworkSites: ZIO[Any, AwsError, List[
      zio.aws.privatenetworks.model.NetworkSite.ReadOnly
    ]] = AwsError.unwrapOptionField("networkSites", networkSites)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse
  ) extends zio.aws.privatenetworks.model.ListNetworkSitesResponse.ReadOnly {
    override val networkSites
        : Optional[List[zio.aws.privatenetworks.model.NetworkSite.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkSites())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.privatenetworks.model.NetworkSite.wrap(item)
          }.toList
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesResponse
  ): zio.aws.privatenetworks.model.ListNetworkSitesResponse.ReadOnly =
    new Wrapper(impl)
}
