package zio.aws.privatenetworks.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.privatenetworks.model.primitives.{
  PaginationToken,
  Arn,
  ListDeviceIdentifiersRequestMaxResultsInteger
}
import scala.jdk.CollectionConverters.*
final case class ListDeviceIdentifiersRequest(
    filters: Optional[
      Map[zio.aws.privatenetworks.model.DeviceIdentifierFilterKeys, Iterable[
        String
      ]]
    ] = Optional.Absent,
    maxResults: Optional[ListDeviceIdentifiersRequestMaxResultsInteger] =
      Optional.Absent,
    networkArn: Arn,
    startToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest = {
    import ListDeviceIdentifiersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filtersWithStrings)
      .optionallyWith(
        maxResults.map(value =>
          ListDeviceIdentifiersRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .networkArn(Arn.unwrap(networkArn): java.lang.String)
      .optionallyWith(
        startToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.startToken)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ListDeviceIdentifiersRequest.ReadOnly =
    zio.aws.privatenetworks.model.ListDeviceIdentifiersRequest
      .wrap(buildAwsValue())
}
object ListDeviceIdentifiersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ListDeviceIdentifiersRequest =
      zio.aws.privatenetworks.model.ListDeviceIdentifiersRequest(
        filters.map(value => value),
        maxResults.map(value => value),
        networkArn,
        startToken.map(value => value)
      )
    def filters: Optional[
      Map[zio.aws.privatenetworks.model.DeviceIdentifierFilterKeys, List[
        String
      ]]
    ]
    def maxResults: Optional[ListDeviceIdentifiersRequestMaxResultsInteger]
    def networkArn: Arn
    def startToken: Optional[PaginationToken]
    def getFilters: ZIO[Any, AwsError, Map[
      zio.aws.privatenetworks.model.DeviceIdentifierFilterKeys,
      List[String]
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults
        : ZIO[Any, AwsError, ListDeviceIdentifiersRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNetworkArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkArn)
    def getStartToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("startToken", startToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest
  ) extends zio.aws.privatenetworks.model.ListDeviceIdentifiersRequest.ReadOnly {
    override val filters: Optional[
      Map[zio.aws.privatenetworks.model.DeviceIdentifierFilterKeys, List[
        String
      ]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.DeviceIdentifierFilterKeys
              .wrap(key) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
    override val maxResults
        : Optional[ListDeviceIdentifiersRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.privatenetworks.model.primitives
            .ListDeviceIdentifiersRequestMaxResultsInteger(value)
        )
    override val networkArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkArn())
    override val startToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.startToken())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListDeviceIdentifiersRequest
  ): zio.aws.privatenetworks.model.ListDeviceIdentifiersRequest.ReadOnly =
    new Wrapper(impl)
}
