package zio.aws.privatenetworks.model
import scala.jdk.CollectionConverters.*
sealed trait HealthStatus {
  def unwrap: software.amazon.awssdk.services.privatenetworks.model.HealthStatus
}
object HealthStatus {
  def wrap(
      value: software.amazon.awssdk.services.privatenetworks.model.HealthStatus
  ): zio.aws.privatenetworks.model.HealthStatus = value match {
    case software.amazon.awssdk.services.privatenetworks.model.HealthStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.privatenetworks.model.HealthStatus.INITIAL =>
      val r = INITIAL
      r
    case software.amazon.awssdk.services.privatenetworks.model.HealthStatus.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.privatenetworks.model.HealthStatus.UNHEALTHY =>
      val r = UNHEALTHY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.privatenetworks.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.HealthStatus =
      software.amazon.awssdk.services.privatenetworks.model.HealthStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIAL extends zio.aws.privatenetworks.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.HealthStatus =
      software.amazon.awssdk.services.privatenetworks.model.HealthStatus.INITIAL
  }
  case object HEALTHY extends zio.aws.privatenetworks.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.HealthStatus =
      software.amazon.awssdk.services.privatenetworks.model.HealthStatus.HEALTHY
  }
  case object UNHEALTHY extends zio.aws.privatenetworks.model.HealthStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.HealthStatus =
      software.amazon.awssdk.services.privatenetworks.model.HealthStatus.UNHEALTHY
  }
}
