package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetOrderRequest(orderArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.GetOrderRequest = {
    import GetOrderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.GetOrderRequest
      .builder()
      .orderArn(Arn.unwrap(orderArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.GetOrderRequest.ReadOnly =
    zio.aws.privatenetworks.model.GetOrderRequest.wrap(buildAwsValue())
}
object GetOrderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.GetOrderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.GetOrderRequest =
      zio.aws.privatenetworks.model.GetOrderRequest(orderArn)
    def orderArn: Arn
    def getOrderArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(orderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetOrderRequest
  ) extends zio.aws.privatenetworks.model.GetOrderRequest.ReadOnly {
    override val orderArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.orderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetOrderRequest
  ): zio.aws.privatenetworks.model.GetOrderRequest.ReadOnly = new Wrapper(impl)
}
