package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetNetworkSiteRequest(networkSiteArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteRequest = {
    import GetNetworkSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteRequest
      .builder()
      .networkSiteArn(Arn.unwrap(networkSiteArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.GetNetworkSiteRequest.ReadOnly =
    zio.aws.privatenetworks.model.GetNetworkSiteRequest.wrap(buildAwsValue())
}
object GetNetworkSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.GetNetworkSiteRequest =
      zio.aws.privatenetworks.model.GetNetworkSiteRequest(networkSiteArn)
    def networkSiteArn: Arn
    def getNetworkSiteArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkSiteArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteRequest
  ) extends zio.aws.privatenetworks.model.GetNetworkSiteRequest.ReadOnly {
    override val networkSiteArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkSiteArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkSiteRequest
  ): zio.aws.privatenetworks.model.GetNetworkSiteRequest.ReadOnly = new Wrapper(
    impl
  )
}
