package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetNetworkResourceRequest(networkResourceArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceRequest = {
    import GetNetworkResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceRequest
      .builder()
      .networkResourceArn(Arn.unwrap(networkResourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.GetNetworkResourceRequest.ReadOnly =
    zio.aws.privatenetworks.model.GetNetworkResourceRequest
      .wrap(buildAwsValue())
}
object GetNetworkResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.GetNetworkResourceRequest =
      zio.aws.privatenetworks.model
        .GetNetworkResourceRequest(networkResourceArn)
    def networkResourceArn: Arn
    def getNetworkResourceArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(networkResourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceRequest
  ) extends zio.aws.privatenetworks.model.GetNetworkResourceRequest.ReadOnly {
    override val networkResourceArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkResourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkResourceRequest
  ): zio.aws.privatenetworks.model.GetNetworkResourceRequest.ReadOnly =
    new Wrapper(impl)
}
