package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetNetworkRequest(networkArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.GetNetworkRequest = {
    import GetNetworkRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkRequest
      .builder()
      .networkArn(Arn.unwrap(networkArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.GetNetworkRequest.ReadOnly =
    zio.aws.privatenetworks.model.GetNetworkRequest.wrap(buildAwsValue())
}
object GetNetworkRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.GetNetworkRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.GetNetworkRequest =
      zio.aws.privatenetworks.model.GetNetworkRequest(networkArn)
    def networkArn: Arn
    def getNetworkArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkRequest
  ) extends zio.aws.privatenetworks.model.GetNetworkRequest.ReadOnly {
    override val networkArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetNetworkRequest
  ): zio.aws.privatenetworks.model.GetNetworkRequest.ReadOnly = new Wrapper(
    impl
  )
}
