package zio.aws.privatenetworks.model
import scala.jdk.CollectionConverters.*
sealed trait DeviceIdentifierFilterKeys {
  def unwrap: software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys
}
object DeviceIdentifierFilterKeys {
  def wrap(
      value: software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys
  ): zio.aws.privatenetworks.model.DeviceIdentifierFilterKeys = value match {
    case software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys.STATUS =>
      val r = STATUS
      r
    case software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys.ORDER =>
      val r = ORDER
      r
    case software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys.TRAFFIC_GROUP =>
      val r = TRAFFIC_GROUP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.privatenetworks.model.DeviceIdentifierFilterKeys {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys =
      software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys.UNKNOWN_TO_SDK_VERSION
  }
  case object STATUS
      extends zio.aws.privatenetworks.model.DeviceIdentifierFilterKeys {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys =
      software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys.STATUS
  }
  case object ORDER
      extends zio.aws.privatenetworks.model.DeviceIdentifierFilterKeys {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys =
      software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys.ORDER
  }
  case object TRAFFIC_GROUP
      extends zio.aws.privatenetworks.model.DeviceIdentifierFilterKeys {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys =
      software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifierFilterKeys.TRAFFIC_GROUP
  }
}
