package zio.aws.privatenetworks.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.privatenetworks.model.primitives.{
  DeviceIdentifierImsiString,
  Arn,
  Timestamp
}
import scala.jdk.CollectionConverters.*
final case class DeviceIdentifier(
    createdAt: Optional[Timestamp] = Optional.Absent,
    deviceIdentifierArn: Optional[Arn] = Optional.Absent,
    iccid: Optional[String] = Optional.Absent,
    imsi: Optional[DeviceIdentifierImsiString] = Optional.Absent,
    networkArn: Optional[Arn] = Optional.Absent,
    orderArn: Optional[String] = Optional.Absent,
    status: Optional[zio.aws.privatenetworks.model.DeviceIdentifierStatus] =
      Optional.Absent,
    trafficGroupArn: Optional[Arn] = Optional.Absent,
    vendor: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifier = {
    import DeviceIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifier
      .builder()
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        deviceIdentifierArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.deviceIdentifierArn)
      .optionallyWith(iccid.map(value => value: java.lang.String))(_.iccid)
      .optionallyWith(
        imsi.map(value =>
          DeviceIdentifierImsiString.unwrap(value): java.lang.String
        )
      )(_.imsi)
      .optionallyWith(
        networkArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.networkArn)
      .optionallyWith(orderArn.map(value => value: java.lang.String))(
        _.orderArn
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        trafficGroupArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.trafficGroupArn)
      .optionallyWith(vendor.map(value => value: java.lang.String))(_.vendor)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly =
    zio.aws.privatenetworks.model.DeviceIdentifier.wrap(buildAwsValue())
}
object DeviceIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.DeviceIdentifier =
      zio.aws.privatenetworks.model.DeviceIdentifier(
        createdAt.map(value => value),
        deviceIdentifierArn.map(value => value),
        iccid.map(value => value),
        imsi.map(value => value),
        networkArn.map(value => value),
        orderArn.map(value => value),
        status.map(value => value),
        trafficGroupArn.map(value => value),
        vendor.map(value => value)
      )
    def createdAt: Optional[Timestamp]
    def deviceIdentifierArn: Optional[Arn]
    def iccid: Optional[String]
    def imsi: Optional[DeviceIdentifierImsiString]
    def networkArn: Optional[Arn]
    def orderArn: Optional[String]
    def status: Optional[zio.aws.privatenetworks.model.DeviceIdentifierStatus]
    def trafficGroupArn: Optional[Arn]
    def vendor: Optional[String]
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getDeviceIdentifierArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("deviceIdentifierArn", deviceIdentifierArn)
    def getIccid: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iccid", iccid)
    def getImsi: ZIO[Any, AwsError, DeviceIdentifierImsiString] =
      AwsError.unwrapOptionField("imsi", imsi)
    def getNetworkArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("networkArn", networkArn)
    def getOrderArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("orderArn", orderArn)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.DeviceIdentifierStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getTrafficGroupArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("trafficGroupArn", trafficGroupArn)
    def getVendor: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vendor", vendor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifier
  ) extends zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly {
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.privatenetworks.model.primitives.Timestamp(value))
    override val deviceIdentifierArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceIdentifierArn())
      .map(value => zio.aws.privatenetworks.model.primitives.Arn(value))
    override val iccid: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.iccid())
      .map(value => value: String)
    override val imsi: Optional[DeviceIdentifierImsiString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.imsi())
        .map(value =>
          zio.aws.privatenetworks.model.primitives
            .DeviceIdentifierImsiString(value)
        )
    override val networkArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.networkArn())
      .map(value => zio.aws.privatenetworks.model.primitives.Arn(value))
    override val orderArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.orderArn())
      .map(value => value: String)
    override val status
        : Optional[zio.aws.privatenetworks.model.DeviceIdentifierStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.privatenetworks.model.DeviceIdentifierStatus.wrap(value)
        )
    override val trafficGroupArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.trafficGroupArn())
      .map(value => zio.aws.privatenetworks.model.primitives.Arn(value))
    override val vendor: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.vendor())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeviceIdentifier
  ): zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly = new Wrapper(impl)
}
