package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{Arn, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteNetworkSiteRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    networkSiteArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteRequest = {
    import DeleteNetworkSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .networkSiteArn(Arn.unwrap(networkSiteArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.DeleteNetworkSiteRequest.ReadOnly =
    zio.aws.privatenetworks.model.DeleteNetworkSiteRequest.wrap(buildAwsValue())
}
object DeleteNetworkSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.DeleteNetworkSiteRequest =
      zio.aws.privatenetworks.model.DeleteNetworkSiteRequest(
        clientToken.map(value => value),
        networkSiteArn
      )
    def clientToken: Optional[ClientToken]
    def networkSiteArn: Arn
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getNetworkSiteArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkSiteArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteRequest
  ) extends zio.aws.privatenetworks.model.DeleteNetworkSiteRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.privatenetworks.model.primitives.ClientToken(value))
    override val networkSiteArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkSiteArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeleteNetworkSiteRequest
  ): zio.aws.privatenetworks.model.DeleteNetworkSiteRequest.ReadOnly =
    new Wrapper(impl)
}
