package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{Arn, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeactivateDeviceIdentifierRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    deviceIdentifierArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.DeactivateDeviceIdentifierRequest = {
    import DeactivateDeviceIdentifierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.DeactivateDeviceIdentifierRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .deviceIdentifierArn(Arn.unwrap(deviceIdentifierArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.DeactivateDeviceIdentifierRequest.ReadOnly =
    zio.aws.privatenetworks.model.DeactivateDeviceIdentifierRequest
      .wrap(buildAwsValue())
}
object DeactivateDeviceIdentifierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.DeactivateDeviceIdentifierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.privatenetworks.model.DeactivateDeviceIdentifierRequest =
      zio.aws.privatenetworks.model.DeactivateDeviceIdentifierRequest(
        clientToken.map(value => value),
        deviceIdentifierArn
      )
    def clientToken: Optional[ClientToken]
    def deviceIdentifierArn: Arn
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDeviceIdentifierArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(deviceIdentifierArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeactivateDeviceIdentifierRequest
  ) extends zio.aws.privatenetworks.model.DeactivateDeviceIdentifierRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.privatenetworks.model.primitives.ClientToken(value))
    override val deviceIdentifierArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.deviceIdentifierArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.DeactivateDeviceIdentifierRequest
  ): zio.aws.privatenetworks.model.DeactivateDeviceIdentifierRequest.ReadOnly =
    new Wrapper(impl)
}
