package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{
  TagValue,
  Arn,
  Description,
  ClientToken,
  Name,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateNetworkSiteRequest(
    availabilityZone: Optional[String] = Optional.Absent,
    availabilityZoneId: Optional[String] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    networkArn: Arn,
    networkSiteName: Name,
    pendingPlan: Optional[zio.aws.privatenetworks.model.SitePlan] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.CreateNetworkSiteRequest = {
    import CreateNetworkSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.CreateNetworkSiteRequest
      .builder()
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(availabilityZoneId.map(value => value: java.lang.String))(
        _.availabilityZoneId
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .networkArn(Arn.unwrap(networkArn): java.lang.String)
      .networkSiteName(Name.unwrap(networkSiteName): java.lang.String)
      .optionallyWith(pendingPlan.map(value => value.buildAwsValue()))(
        _.pendingPlan
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.CreateNetworkSiteRequest.ReadOnly =
    zio.aws.privatenetworks.model.CreateNetworkSiteRequest.wrap(buildAwsValue())
}
object CreateNetworkSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.CreateNetworkSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.CreateNetworkSiteRequest =
      zio.aws.privatenetworks.model.CreateNetworkSiteRequest(
        availabilityZone.map(value => value),
        availabilityZoneId.map(value => value),
        clientToken.map(value => value),
        description.map(value => value),
        networkArn,
        networkSiteName,
        pendingPlan.map(value => value.asEditable),
        tags.map(value => value)
      )
    def availabilityZone: Optional[String]
    def availabilityZoneId: Optional[String]
    def clientToken: Optional[ClientToken]
    def description: Optional[Description]
    def networkArn: Arn
    def networkSiteName: Name
    def pendingPlan: Optional[zio.aws.privatenetworks.model.SitePlan.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAvailabilityZoneId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZoneId", availabilityZoneId)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNetworkArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkArn)
    def getNetworkSiteName: ZIO[Any, Nothing, Name] =
      ZIO.succeed(networkSiteName)
    def getPendingPlan
        : ZIO[Any, AwsError, zio.aws.privatenetworks.model.SitePlan.ReadOnly] =
      AwsError.unwrapOptionField("pendingPlan", pendingPlan)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.CreateNetworkSiteRequest
  ) extends zio.aws.privatenetworks.model.CreateNetworkSiteRequest.ReadOnly {
    override val availabilityZone: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZone())
      .map(value => value: String)
    override val availabilityZoneId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.availabilityZoneId())
      .map(value => value: String)
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.privatenetworks.model.primitives.ClientToken(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.privatenetworks.model.primitives.Description(value))
    override val networkArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkArn())
    override val networkSiteName: Name =
      zio.aws.privatenetworks.model.primitives.Name(impl.networkSiteName())
    override val pendingPlan
        : Optional[zio.aws.privatenetworks.model.SitePlan.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pendingPlan())
        .map(value => zio.aws.privatenetworks.model.SitePlan.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.primitives.TagKey(
              key
            ) -> zio.aws.privatenetworks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.CreateNetworkSiteRequest
  ): zio.aws.privatenetworks.model.CreateNetworkSiteRequest.ReadOnly =
    new Wrapper(impl)
}
