package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ConfigureAccessPointResponse(
    accessPoint: zio.aws.privatenetworks.model.NetworkResource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointResponse = {
    import ConfigureAccessPointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointResponse
      .builder()
      .accessPoint(accessPoint.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ConfigureAccessPointResponse.ReadOnly =
    zio.aws.privatenetworks.model.ConfigureAccessPointResponse
      .wrap(buildAwsValue())
}
object ConfigureAccessPointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ConfigureAccessPointResponse =
      zio.aws.privatenetworks.model
        .ConfigureAccessPointResponse(accessPoint.asEditable)
    def accessPoint: zio.aws.privatenetworks.model.NetworkResource.ReadOnly
    def getAccessPoint: ZIO[
      Any,
      Nothing,
      zio.aws.privatenetworks.model.NetworkResource.ReadOnly
    ] = ZIO.succeed(accessPoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointResponse
  ) extends zio.aws.privatenetworks.model.ConfigureAccessPointResponse.ReadOnly {
    override val accessPoint
        : zio.aws.privatenetworks.model.NetworkResource.ReadOnly =
      zio.aws.privatenetworks.model.NetworkResource.wrap(impl.accessPoint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ConfigureAccessPointResponse
  ): zio.aws.privatenetworks.model.ConfigureAccessPointResponse.ReadOnly =
    new Wrapper(impl)
}
