package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActivateNetworkSiteResponse(
    networkSite: Optional[zio.aws.privatenetworks.model.NetworkSite] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteResponse = {
    import ActivateNetworkSiteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteResponse
      .builder()
      .optionallyWith(networkSite.map(value => value.buildAwsValue()))(
        _.networkSite
      )
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ActivateNetworkSiteResponse.ReadOnly =
    zio.aws.privatenetworks.model.ActivateNetworkSiteResponse
      .wrap(buildAwsValue())
}
object ActivateNetworkSiteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ActivateNetworkSiteResponse =
      zio.aws.privatenetworks.model
        .ActivateNetworkSiteResponse(networkSite.map(value => value.asEditable))
    def networkSite
        : Optional[zio.aws.privatenetworks.model.NetworkSite.ReadOnly]
    def getNetworkSite: ZIO[
      Any,
      AwsError,
      zio.aws.privatenetworks.model.NetworkSite.ReadOnly
    ] = AwsError.unwrapOptionField("networkSite", networkSite)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteResponse
  ) extends zio.aws.privatenetworks.model.ActivateNetworkSiteResponse.ReadOnly {
    override val networkSite
        : Optional[zio.aws.privatenetworks.model.NetworkSite.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkSite())
        .map(value => zio.aws.privatenetworks.model.NetworkSite.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ActivateNetworkSiteResponse
  ): zio.aws.privatenetworks.model.ActivateNetworkSiteResponse.ReadOnly =
    new Wrapper(impl)
}
