package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActivateDeviceIdentifierResponse(
    deviceIdentifier: zio.aws.privatenetworks.model.DeviceIdentifier,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierResponse = {
    import ActivateDeviceIdentifierResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierResponse
      .builder()
      .deviceIdentifier(deviceIdentifier.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse.ReadOnly =
    zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse
      .wrap(buildAwsValue())
}
object ActivateDeviceIdentifierResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse =
      zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse(
        deviceIdentifier.asEditable,
        tags.map(value => value)
      )
    def deviceIdentifier
        : zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def getDeviceIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly
    ] = ZIO.succeed(deviceIdentifier)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierResponse
  ) extends zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse.ReadOnly {
    override val deviceIdentifier
        : zio.aws.privatenetworks.model.DeviceIdentifier.ReadOnly =
      zio.aws.privatenetworks.model.DeviceIdentifier
        .wrap(impl.deviceIdentifier())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.primitives.TagKey(
              key
            ) -> zio.aws.privatenetworks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierResponse
  ): zio.aws.privatenetworks.model.ActivateDeviceIdentifierResponse.ReadOnly =
    new Wrapper(impl)
}
