package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{Arn, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActivateDeviceIdentifierRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    deviceIdentifierArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierRequest = {
    import ActivateDeviceIdentifierRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .deviceIdentifierArn(Arn.unwrap(deviceIdentifierArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ActivateDeviceIdentifierRequest.ReadOnly =
    zio.aws.privatenetworks.model.ActivateDeviceIdentifierRequest
      .wrap(buildAwsValue())
}
object ActivateDeviceIdentifierRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.privatenetworks.model.ActivateDeviceIdentifierRequest =
      zio.aws.privatenetworks.model.ActivateDeviceIdentifierRequest(
        clientToken.map(value => value),
        deviceIdentifierArn
      )
    def clientToken: Optional[ClientToken]
    def deviceIdentifierArn: Arn
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDeviceIdentifierArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(deviceIdentifierArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierRequest
  ) extends zio.aws.privatenetworks.model.ActivateDeviceIdentifierRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.privatenetworks.model.primitives.ClientToken(value))
    override val deviceIdentifierArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.deviceIdentifierArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ActivateDeviceIdentifierRequest
  ): zio.aws.privatenetworks.model.ActivateDeviceIdentifierRequest.ReadOnly =
    new Wrapper(impl)
}
