package zio.aws.privatenetworks.model
import scala.jdk.CollectionConverters.*
sealed trait AcknowledgmentStatus {
  def unwrap: software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus
}
object AcknowledgmentStatus {
  def wrap(
      value: software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus
  ): zio.aws.privatenetworks.model.AcknowledgmentStatus = value match {
    case software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus.ACKNOWLEDGING =>
      val r = ACKNOWLEDGING
      r
    case software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus.ACKNOWLEDGED =>
      val r = ACKNOWLEDGED
      r
    case software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus.UNACKNOWLEDGED =>
      val r = UNACKNOWLEDGED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.privatenetworks.model.AcknowledgmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus =
      software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACKNOWLEDGING
      extends zio.aws.privatenetworks.model.AcknowledgmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus =
      software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus.ACKNOWLEDGING
  }
  case object ACKNOWLEDGED
      extends zio.aws.privatenetworks.model.AcknowledgmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus =
      software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus.ACKNOWLEDGED
  }
  case object UNACKNOWLEDGED
      extends zio.aws.privatenetworks.model.AcknowledgmentStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus =
      software.amazon.awssdk.services.privatenetworks.model.AcknowledgmentStatus.UNACKNOWLEDGED
  }
}
