package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AcknowledgeOrderReceiptRequest(orderArn: Arn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptRequest = {
    import AcknowledgeOrderReceiptRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptRequest
      .builder()
      .orderArn(Arn.unwrap(orderArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.AcknowledgeOrderReceiptRequest.ReadOnly =
    zio.aws.privatenetworks.model.AcknowledgeOrderReceiptRequest
      .wrap(buildAwsValue())
}
object AcknowledgeOrderReceiptRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.privatenetworks.model.AcknowledgeOrderReceiptRequest =
      zio.aws.privatenetworks.model.AcknowledgeOrderReceiptRequest(orderArn)
    def orderArn: Arn
    def getOrderArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(orderArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptRequest
  ) extends zio.aws.privatenetworks.model.AcknowledgeOrderReceiptRequest.ReadOnly {
    override val orderArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.orderArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.AcknowledgeOrderReceiptRequest
  ): zio.aws.privatenetworks.model.AcknowledgeOrderReceiptRequest.ReadOnly =
    new Wrapper(impl)
}
