package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{Arn, Description, ClientToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateNetworkSiteRequest(
    clientToken: Optional[ClientToken] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    networkSiteArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSiteRequest = {
    import UpdateNetworkSiteRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSiteRequest
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .networkSiteArn(Arn.unwrap(networkSiteArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.UpdateNetworkSiteRequest.ReadOnly =
    zio.aws.privatenetworks.model.UpdateNetworkSiteRequest.wrap(buildAwsValue())
}
object UpdateNetworkSiteRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSiteRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.UpdateNetworkSiteRequest =
      zio.aws.privatenetworks.model.UpdateNetworkSiteRequest(
        clientToken.map(value => value),
        description.map(value => value),
        networkSiteArn
      )
    def clientToken: Optional[ClientToken]
    def description: Optional[Description]
    def networkSiteArn: Arn
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getNetworkSiteArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkSiteArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSiteRequest
  ) extends zio.aws.privatenetworks.model.UpdateNetworkSiteRequest.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.privatenetworks.model.primitives.ClientToken(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.privatenetworks.model.primitives.Description(value))
    override val networkSiteArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkSiteArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.UpdateNetworkSiteRequest
  ): zio.aws.privatenetworks.model.UpdateNetworkSiteRequest.ReadOnly =
    new Wrapper(impl)
}
