package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TrackingInformation(
    trackingNumber: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.TrackingInformation = {
    import TrackingInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.TrackingInformation
      .builder()
      .optionallyWith(trackingNumber.map(value => value: java.lang.String))(
        _.trackingNumber
      )
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.TrackingInformation.ReadOnly =
    zio.aws.privatenetworks.model.TrackingInformation.wrap(buildAwsValue())
}
object TrackingInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.TrackingInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.TrackingInformation =
      zio.aws.privatenetworks.model
        .TrackingInformation(trackingNumber.map(value => value))
    def trackingNumber: Optional[String]
    def getTrackingNumber: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("trackingNumber", trackingNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.TrackingInformation
  ) extends zio.aws.privatenetworks.model.TrackingInformation.ReadOnly {
    override val trackingNumber: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.trackingNumber())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.TrackingInformation
  ): zio.aws.privatenetworks.model.TrackingInformation.ReadOnly = new Wrapper(
    impl
  )
}
