package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{TagValue, TagKey, Arn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.TagResourceRequest.ReadOnly =
    zio.aws.privatenetworks.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.TagResourceRequest =
      zio.aws.privatenetworks.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: Arn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.TagResourceRequest
  ) extends zio.aws.privatenetworks.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.privatenetworks.model.primitives.TagKey(
          key
        ) -> zio.aws.privatenetworks.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.TagResourceRequest
  ): zio.aws.privatenetworks.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
