package zio.aws.privatenetworks.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SitePlan(
    options: Optional[Iterable[zio.aws.privatenetworks.model.NameValuePair]] =
      Optional.Absent,
    resourceDefinitions: Optional[
      Iterable[zio.aws.privatenetworks.model.NetworkResourceDefinition]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.SitePlan = {
    import SitePlan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.SitePlan
      .builder()
      .optionallyWith(
        options.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.options)
      .optionallyWith(
        resourceDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.resourceDefinitions)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.SitePlan.ReadOnly =
    zio.aws.privatenetworks.model.SitePlan.wrap(buildAwsValue())
}
object SitePlan {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.SitePlan
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.SitePlan =
      zio.aws.privatenetworks.model.SitePlan(
        options.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def options
        : Optional[List[zio.aws.privatenetworks.model.NameValuePair.ReadOnly]]
    def resourceDefinitions: Optional[
      List[zio.aws.privatenetworks.model.NetworkResourceDefinition.ReadOnly]
    ]
    def getOptions: ZIO[Any, AwsError, List[
      zio.aws.privatenetworks.model.NameValuePair.ReadOnly
    ]] = AwsError.unwrapOptionField("options", options)
    def getResourceDefinitions: ZIO[Any, AwsError, List[
      zio.aws.privatenetworks.model.NetworkResourceDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("resourceDefinitions", resourceDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.SitePlan
  ) extends zio.aws.privatenetworks.model.SitePlan.ReadOnly {
    override val options
        : Optional[List[zio.aws.privatenetworks.model.NameValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.privatenetworks.model.NameValuePair.wrap(item)
          }.toList
        )
    override val resourceDefinitions: Optional[
      List[zio.aws.privatenetworks.model.NetworkResourceDefinition.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceDefinitions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.privatenetworks.model.NetworkResourceDefinition.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.SitePlan
  ): zio.aws.privatenetworks.model.SitePlan.ReadOnly = new Wrapper(impl)
}
