package zio.aws.privatenetworks.model
import scala.jdk.CollectionConverters.*
sealed trait NetworkStatus {
  def unwrap
      : software.amazon.awssdk.services.privatenetworks.model.NetworkStatus
}
object NetworkStatus {
  def wrap(
      value: software.amazon.awssdk.services.privatenetworks.model.NetworkStatus
  ): zio.aws.privatenetworks.model.NetworkStatus = value match {
    case software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.DEPROVISIONING =>
      val r = DEPROVISIONING
      r
    case software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.DELETED =>
      val r = DELETED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.privatenetworks.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.privatenetworks.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.CREATED
  }
  case object PROVISIONING extends zio.aws.privatenetworks.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.PROVISIONING
  }
  case object AVAILABLE extends zio.aws.privatenetworks.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.AVAILABLE
  }
  case object DEPROVISIONING
      extends zio.aws.privatenetworks.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.DEPROVISIONING
  }
  case object DELETED extends zio.aws.privatenetworks.model.NetworkStatus {
    override def unwrap
        : software.amazon.awssdk.services.privatenetworks.model.NetworkStatus =
      software.amazon.awssdk.services.privatenetworks.model.NetworkStatus.DELETED
  }
}
