package zio.aws.privatenetworks.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.privatenetworks.model.primitives.{
  PaginationToken,
  Arn,
  ListNetworkSitesRequestMaxResultsInteger
}
import scala.jdk.CollectionConverters.*
final case class ListNetworkSitesRequest(
    filters: Optional[
      Map[zio.aws.privatenetworks.model.NetworkSiteFilterKeys, Iterable[String]]
    ] = Optional.Absent,
    maxResults: Optional[ListNetworkSitesRequestMaxResultsInteger] =
      Optional.Absent,
    networkArn: Arn,
    startToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest = {
    import ListNetworkSitesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filtersWithStrings)
      .optionallyWith(
        maxResults.map(value =>
          ListNetworkSitesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .networkArn(Arn.unwrap(networkArn): java.lang.String)
      .optionallyWith(
        startToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.startToken)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ListNetworkSitesRequest.ReadOnly =
    zio.aws.privatenetworks.model.ListNetworkSitesRequest.wrap(buildAwsValue())
}
object ListNetworkSitesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ListNetworkSitesRequest =
      zio.aws.privatenetworks.model.ListNetworkSitesRequest(
        filters.map(value => value),
        maxResults.map(value => value),
        networkArn,
        startToken.map(value => value)
      )
    def filters: Optional[
      Map[zio.aws.privatenetworks.model.NetworkSiteFilterKeys, List[String]]
    ]
    def maxResults: Optional[ListNetworkSitesRequestMaxResultsInteger]
    def networkArn: Arn
    def startToken: Optional[PaginationToken]
    def getFilters: ZIO[Any, AwsError, Map[
      zio.aws.privatenetworks.model.NetworkSiteFilterKeys,
      List[String]
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults
        : ZIO[Any, AwsError, ListNetworkSitesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNetworkArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkArn)
    def getStartToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("startToken", startToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest
  ) extends zio.aws.privatenetworks.model.ListNetworkSitesRequest.ReadOnly {
    override val filters: Optional[
      Map[zio.aws.privatenetworks.model.NetworkSiteFilterKeys, List[String]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.NetworkSiteFilterKeys
              .wrap(key) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
    override val maxResults
        : Optional[ListNetworkSitesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.privatenetworks.model.primitives
            .ListNetworkSitesRequestMaxResultsInteger(value)
        )
    override val networkArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkArn())
    override val startToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.startToken())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListNetworkSitesRequest
  ): zio.aws.privatenetworks.model.ListNetworkSitesRequest.ReadOnly =
    new Wrapper(impl)
}
