package zio.aws.privatenetworks.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.privatenetworks.model.primitives.{
  PaginationToken,
  Arn,
  ListNetworkResourcesRequestMaxResultsInteger
}
import scala.jdk.CollectionConverters.*
final case class ListNetworkResourcesRequest(
    filters: Optional[
      Map[zio.aws.privatenetworks.model.NetworkResourceFilterKeys, Iterable[
        String
      ]]
    ] = Optional.Absent,
    maxResults: Optional[ListNetworkResourcesRequestMaxResultsInteger] =
      Optional.Absent,
    networkArn: Arn,
    startToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest = {
    import ListNetworkResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filtersWithStrings)
      .optionallyWith(
        maxResults.map(value =>
          ListNetworkResourcesRequestMaxResultsInteger.unwrap(value): Integer
        )
      )(_.maxResults)
      .networkArn(Arn.unwrap(networkArn): java.lang.String)
      .optionallyWith(
        startToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.startToken)
      .build()
  }
  def asReadOnly
      : zio.aws.privatenetworks.model.ListNetworkResourcesRequest.ReadOnly =
    zio.aws.privatenetworks.model.ListNetworkResourcesRequest
      .wrap(buildAwsValue())
}
object ListNetworkResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.ListNetworkResourcesRequest =
      zio.aws.privatenetworks.model.ListNetworkResourcesRequest(
        filters.map(value => value),
        maxResults.map(value => value),
        networkArn,
        startToken.map(value => value)
      )
    def filters: Optional[
      Map[zio.aws.privatenetworks.model.NetworkResourceFilterKeys, List[String]]
    ]
    def maxResults: Optional[ListNetworkResourcesRequestMaxResultsInteger]
    def networkArn: Arn
    def startToken: Optional[PaginationToken]
    def getFilters: ZIO[Any, AwsError, Map[
      zio.aws.privatenetworks.model.NetworkResourceFilterKeys,
      List[String]
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults
        : ZIO[Any, AwsError, ListNetworkResourcesRequestMaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNetworkArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(networkArn)
    def getStartToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("startToken", startToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest
  ) extends zio.aws.privatenetworks.model.ListNetworkResourcesRequest.ReadOnly {
    override val filters: Optional[
      Map[zio.aws.privatenetworks.model.NetworkResourceFilterKeys, List[String]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.NetworkResourceFilterKeys
              .wrap(key) -> value.asScala.map { item =>
              item: String
            }.toList
          })
          .toMap
      )
    override val maxResults
        : Optional[ListNetworkResourcesRequestMaxResultsInteger] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.privatenetworks.model.primitives
            .ListNetworkResourcesRequestMaxResultsInteger(value)
        )
    override val networkArn: Arn =
      zio.aws.privatenetworks.model.primitives.Arn(impl.networkArn())
    override val startToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.startToken())
      .map(value =>
        zio.aws.privatenetworks.model.primitives.PaginationToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.ListNetworkResourcesRequest
  ): zio.aws.privatenetworks.model.ListNetworkResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
