package zio.aws.privatenetworks.model
import zio.aws.privatenetworks.model.primitives.{TagValue, TagKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetOrderResponse(
    order: zio.aws.privatenetworks.model.Order,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.privatenetworks.model.GetOrderResponse = {
    import GetOrderResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.privatenetworks.model.GetOrderResponse
      .builder()
      .order(order.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.privatenetworks.model.GetOrderResponse.ReadOnly =
    zio.aws.privatenetworks.model.GetOrderResponse.wrap(buildAwsValue())
}
object GetOrderResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.privatenetworks.model.GetOrderResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.privatenetworks.model.GetOrderResponse =
      zio.aws.privatenetworks.model
        .GetOrderResponse(order.asEditable, tags.map(value => value))
    def order: zio.aws.privatenetworks.model.Order.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def getOrder
        : ZIO[Any, Nothing, zio.aws.privatenetworks.model.Order.ReadOnly] =
      ZIO.succeed(order)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetOrderResponse
  ) extends zio.aws.privatenetworks.model.GetOrderResponse.ReadOnly {
    override val order: zio.aws.privatenetworks.model.Order.ReadOnly =
      zio.aws.privatenetworks.model.Order.wrap(impl.order())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.privatenetworks.model.primitives.TagKey(
              key
            ) -> zio.aws.privatenetworks.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.privatenetworks.model.GetOrderResponse
  ): zio.aws.privatenetworks.model.GetOrderResponse.ReadOnly = new Wrapper(impl)
}
